/*
 * Decompiled with CFR 0.152.
 */
package minecrafttransportsimulator.blocks.tileentities.instances;

import minecrafttransportsimulator.baseclasses.ComputedVariable;
import minecrafttransportsimulator.baseclasses.Point3D;
import minecrafttransportsimulator.baseclasses.RotationMatrix;
import minecrafttransportsimulator.blocks.tileentities.components.ATileEntityBase;
import minecrafttransportsimulator.items.instances.ItemDecor;
import minecrafttransportsimulator.jsondefs.JSONDecor;
import minecrafttransportsimulator.jsondefs.JSONItem;
import minecrafttransportsimulator.mcinterface.AWrapperWorld;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.IWrapperPlayer;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import minecrafttransportsimulator.packets.instances.PacketEntityGUIRequest;
import minecrafttransportsimulator.packets.instances.PacketEntityInteractGUI;

public class TileEntityDecor
extends ATileEntityBase<JSONDecor> {
    public final ComputedVariable clickedVar;
    public final ComputedVariable activatedVar;
    private final ComputedVariable lightLevelVar;
    public boolean craftedItem;

    public TileEntityDecor(AWrapperWorld world, Point3D position, IWrapperPlayer placingPlayer, ItemDecor item, IWrapperNBT data) {
        super(world, position, placingPlayer, item, data);
        if (world.isBlockBelowBottomSlab(position)) {
            this.position.y -= 0.5;
            this.boundingBox.globalCenter.set(this.position);
        }
        this.boundingBox.heightRadius = (double)((JSONDecor)this.definition).decor.height / 2.0;
        this.boundingBox.globalCenter.y += this.boundingBox.heightRadius;
        if (Math.abs(new Point3D((double)0.0, (double)0.0, (double)1.0).rotate((RotationMatrix)this.orientation).z) == 1.0) {
            this.boundingBox.widthRadius = (double)((JSONDecor)this.definition).decor.width / 2.0;
            this.boundingBox.depthRadius = (double)((JSONDecor)this.definition).decor.depth / 2.0;
        } else {
            this.boundingBox.widthRadius = (double)((JSONDecor)this.definition).decor.depth / 2.0;
            this.boundingBox.depthRadius = (double)((JSONDecor)this.definition).decor.width / 2.0;
        }
        this.clickedVar = new ComputedVariable(this, "clicked", data);
        this.activatedVar = new ComputedVariable(this, "activated", data);
        this.lightLevelVar = new ComputedVariable(this, "lightLevel");
    }

    @Override
    public void update() {
        this.updateVariableModifiers();
        super.update();
        if (this.clickedVar.isActive) {
            this.clickedVar.toggle(false);
        }
    }

    @Override
    public boolean updateRider() {
        if (super.updateRider()) {
            this.position.y += (double)((JSONDecor)this.definition).decor.sittingOffset;
            this.rider.setPosition(this.position, false);
            this.position.y -= (double)((JSONDecor)this.definition).decor.sittingOffset;
            return true;
        }
        return false;
    }

    @Override
    public boolean interact(IWrapperPlayer player) {
        if (player.isHoldingItemType(JSONItem.ItemComponentType.PAINT_GUN)) {
            return false;
        }
        if (player.isHoldingItemType(JSONItem.ItemComponentType.WRENCH)) {
            if (player.isSneaking() && !this.text.isEmpty()) {
                player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.TEXT_EDITOR));
                this.playersInteracting.add(player);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
            } else {
                this.clickedVar.setTo(1.0, true);
                this.activatedVar.toggle(true);
            }
        } else if (((JSONDecor)this.definition).decor.type == JSONDecor.DecorComponentType.SEAT) {
            this.setRider(player, true);
        } else {
            if (((JSONDecor)this.definition).decor.crafting != null) {
                player.sendPacket(new PacketEntityGUIRequest(this, player, PacketEntityGUIRequest.EntityGUIType.PART_BENCH));
                this.playersInteracting.add(player);
                InterfaceManager.packetInterface.sendToAllClients(new PacketEntityInteractGUI(this, player, true));
            }
            this.clickedVar.setTo(1.0, true);
            this.activatedVar.toggle(true);
        }
        return true;
    }

    @Override
    public int getRotationIncrement() {
        return 90;
    }

    @Override
    public float getLightProvided() {
        return (float)this.lightLevelVar.currentValue;
    }

    @Override
    public void setVariableDefaults() {
        super.setVariableDefaults();
        this.lightLevelVar.setTo(((JSONDecor)this.definition).decor.lightLevel, false);
    }
}

